/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobReclamationTest
extends BaseJDBCTestCase {
    private static final int NUM_THREADS = 2;
    private static int expectedNumAllocated = 5;

    public ClobReclamationTest(String string) {
        super(string);
    }

    public void testMultiThreadedUpdate(final boolean bl, boolean bl2) throws SQLException, InterruptedException {
        int n;
        Connection connection = this.getConnection();
        final String string = Formatters.repeatChar("a", 33000);
        Thread[] threadArray = new Thread[2];
        for (n = 0; n < 2; ++n) {
            final int n2 = bl2 ? 1 : n + 1;
            threadArray[n] = new Thread(){

                @Override
                public void run() {
                    try {
                        Connection connection = ClobReclamationTest.this.openDefaultConnection();
                        connection.setAutoCommit(false);
                        ClobReclamationTest.fiveHundredUpdates(connection, string, n2, bl);
                    }
                    catch (SQLException sQLException) {
                        Assert.fail((String)sQLException.getMessage());
                    }
                }
            };
        }
        for (n = 0; n < 2; ++n) {
            threadArray[n].start();
        }
        for (n = 0; n < 2; ++n) {
            threadArray[n].join();
        }
        this.checkNumAllocatedPages("CLOBTAB", expectedNumAllocated, false);
    }

    private void checkNumAllocatedPages(String string, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT NUMALLOCATEDPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (true) {
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n4 = resultSet.getInt(1);
            if (n4 == n) break;
            if (bl) {
                block9: {
                    if (n4 < n2) {
                        ++n3;
                        try {
                            if (n3 <= 1) {
                                Thread.sleep(10000L);
                                break block9;
                            }
                            Thread.sleep(60000 * n3);
                        }
                        catch (Exception exception) {}
                    } else {
                        ClobReclamationTest.assertTrue((String)("Fail with retries -- num_allocated_pages:" + n4 + " == expectedAlloc: " + n + " previous_alloc_count: " + n2 + " num_retries: " + n3), (n4 == n ? 1 : 0) != 0);
                    }
                }
                if (n3 > 1) {
                    n2 = n4;
                }
            } else {
                ClobReclamationTest.assertTrue((String)("Fail, no retries -- num_allocated_pages:" + n4 + " > expectedAlloc: " + n), (n4 == n ? 1 : 0) != 0);
            }
            resultSet.close();
        }
    }

    private void checkNumFreePages(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT NUMFREEPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"" + n}});
    }

    private void checkNumFreePagesMax(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT NUMFREEPAGES FROM  new org.apache.derby.diag.SpaceTable('APP',?) t WHERE CONGLOMERATENAME = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n2 = resultSet.getInt(1);
        ClobReclamationTest.assertTrue((String)("Fail -- numfreerows:" + n2 + " > expectedFreeMax: " + n), (n2 < n ? 1 : 0) != 0);
        resultSet.close();
        preparedStatement.close();
    }

    private static void fiveHundredUpdates(Connection connection, String string, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE CLOBTAB SET C = ? WHERE I = ?");
        for (int i = 0; i < 500; ++i) {
            if (bl) {
                Statement statement = connection.createStatement();
                statement.executeUpdate("LOCK TABLE CLOBTAB IN EXCLUSIVE MODE");
            }
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    public void testMultiThreadedUpdateRowLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, false);
    }

    public void xtestMultiThreadedUpdateTableLocking() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(true, false);
    }

    public void xtestMultiThreadUpdateSingleRow() throws SQLException, InterruptedException {
        this.testMultiThreadedUpdate(false, true);
    }

    public void testReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        String string = Formatters.repeatChar("a", 33000);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTAB2 VALUES(?,?)");
        for (int i = 0; i < 500; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            this.rollback();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkNumAllocatedPages("CLOBTAB2", 1, true);
    }

    public void testBlobLinkedListReclamationOnRollback() throws SQLException {
        this.setAutoCommit(false);
        int n = 200000;
        String string = Formatters.repeatChar("a", 200000);
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CLOBTAB3 VALUES(?,?)");
        int n2 = 500;
        for (int i = 0; i < n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            this.rollback();
        }
        preparedStatement.close();
        this.checkNumAllocatedPages("CLOBTAB3", 1, true);
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        callableStatement.setString(1, "APP");
        callableStatement.setString(2, "CLOBTAB3");
        callableStatement.executeUpdate();
        this.checkNumAllocatedPages("CLOBTAB3", 1, false);
        this.checkNumFreePages("CLOBTAB3", 0);
        this.commit();
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(ClobReclamationTest.class);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                statement.executeUpdate("CREATE TABLE CLOBTAB (I INT  PRIMARY KEY NOT NULL, c CLOB)");
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO CLOBTAB VALUES(?,?)");
                String string = "hello";
                for (int i = 1; i <= 2; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                }
                statement.executeUpdate("CREATE TABLE CLOBTAB2 (I INT, C CLOB)");
                statement.executeUpdate("CREATE TABLE CLOBTAB3 (I INT, C CLOB)");
            }

            @Override
            protected void tearDown() throws Exception {
                super.tearDown();
            }
        };
    }
}

